/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.ParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class BlockParameterPanel
extends ParameterPanel
implements ParameterUpdateListener {
    protected JCheckBox cbRemanence;
    protected boolean fSimulationMode;
    private JLabel fBlockNameLabel;
    private LengthRestrictedJTextField fBlockName;

    public BlockParameterPanel() {
    }

    public BlockParameterPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference);
        this.fSimulationMode = simulationMode;
        this.setPanelName(Language.getString("dialog.parameter.parameter", "Parameter"));
        this.addRemanence();
        this.addBlockName((BlockParameter)parameterReference);
    }

    private void addBlockName(BlockParameter parameter) {
        if (parameter.supportsUserDefinedName()) {
            WiringDiagram wd;
            int[] freeResources;
            this.blocknamePanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = null;
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 5, 0, 0);
            this.fBlockNameLabel = new JLabel(Language.getString("global.blockname", "Blockname"));
            this.blocknamePanel.add((Component)this.fBlockNameLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 5, 0, 0);
            this.fBlockName = new LengthRestrictedJTextField(8);
            this.fBlockName.setMinimumSize(this.fBlockName.getPreferredSize());
            this.fBlockName.setMask(LengthRestrictedJTextField.ASCII);
            this.blocknamePanel.add((Component)this.fBlockName, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.blocknamePanel.add((Component)new JPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 0, 5, 0);
            this.blocknamePanel.add((Component)new JSeparator(), gbc);
            if (!parameter.getBlock().isUserDefinedNameAvailable() && (freeResources = (wd = parameter.getBlock().getWiringDiagram()).getFreeResources())[15] == 0) {
                this.fBlockNameLabel.setEnabled(false);
                this.fBlockName.setEnabled(false);
                this.fBlockName.setOpaque(false);
            }
        }
    }

    private void addRemanence() {
        this.cbRemanence = new JCheckBox();
        BlockParameter blockParameter = (BlockParameter)this.fParameterReference;
        if (blockParameter.getRemanenceAvailable()) {
            this.globalParamPane.add(this.cbRemanence);
            int[] freeResources = blockParameter.getBlock().getWiringDiagram().getFreeResources();
            if (!blockParameter.getRemanenceObject().getRemanence() && freeResources[2] < blockParameter.getNeededREMOrRAM()) {
                this.cbRemanence.setEnabled(false);
            }
            if (blockParameter.getRemanenceObject().getRemanence() && freeResources[1] < blockParameter.getNeededREMOrRAM()) {
                this.cbRemanence.setEnabled(false);
            }
        }
    }

    public boolean checkChanged() {
        BlockParameter param = (BlockParameter)this.fParameterReference;
        if (param.getRemanenceAvailable() && this.cbRemanence.isSelected() != param.getRemanenceObject().getRemanence()) {
            return true;
        }
        if (this.fBlockName != null) {
            String blockname = param.getBlock().getUserDefinedName();
            if (blockname == null) {
                blockname = "";
            }
            if (!this.fBlockName.getText().equals(blockname)) {
                return true;
            }
        }
        return false;
    }

    public boolean checkFieldContents() {
        return true;
    }

    public void closeEvent() {
        ((BlockParameter)this.getParameterReference()).removeParameterUpdateListener(this);
    }

    public String getHelpIdString() {
        return ((BlockParameter)this.getParameterReference()).getBlock().getLanguageKey();
    }

    public JComponent getMinimizedPanel() {
        return null;
    }

    public boolean isResizable() {
        return true;
    }

    public void loadFieldContents() {
        BlockParameter blockParameter = (BlockParameter)this.fParameterReference;
        if (blockParameter.getRemanenceAvailable() && this.cbRemanence != null) {
            this.cbRemanence.setSelected(blockParameter.getRemanenceObject().getRemanence());
        }
        Block block = blockParameter.getBlock();
        if (blockParameter.supportsUserDefinedName() && block.isUserDefinedNameAvailable()) {
            this.fBlockName.setText(block.getUserDefinedName());
        }
    }

    public void parameterUpdated(ParameterUpdateEvent e) {
    }

    protected String replaceLineFeedBySlash(String string) {
        StringBuffer buffer = new StringBuffer(string);
        int index = -1;
        while ((index = buffer.toString().indexOf("\n")) != -1) {
            buffer.replace(index, index + 1, " / ");
        }
        return buffer.toString();
    }

    public void setLabels() {
        BlockParameter blockParameter = (BlockParameter)this.fParameterReference;
        blockParameter = (BlockParameter)this.fParameterReference;
        if (blockParameter.getRemanenceAvailable() && this.cbRemanence != null) {
            this.cbRemanence.setText(Language.getString("dialog.parameter.remanence", "Remanence"));
        }
    }

    public void storeFieldContents() {
        BlockParameter blockParameter = (BlockParameter)this.fParameterReference;
        if (blockParameter.getRemanenceAvailable() && this.cbRemanence != null) {
            blockParameter.getRemanenceObject().setRemanence(this.cbRemanence.isSelected());
        }
        if (this.fBlockName != null && this.fBlockName.isEnabled()) {
            blockParameter.getBlock().setUserDefinedName(this.fBlockName.getText());
        }
    }

    protected JCheckBox getRemanenceField() {
        return this.cbRemanence;
    }

    protected Hardware getHardware() {
        return ((BlockParameter)this.getParameterReference()).getBlock().getHardware();
    }
}

